
% This script reads imaris files and and gets statistics for both surface
% and spot objects to calculate percentage of RNA spots overlapping
% with protein signals. Written by Ingrid Brust-Mascher and Xueer
% Jiang, Jao lab, University of California, Davis (April 2019). Publications
% that have utilized this script should acknowledge the resource and cite
% our Bio-Protocol Paper.




clear
% define fpath: location of a folder containing the processed imaris images
fpath='/Users/Jao_lab/Documents/MATLAB/touching_data_test';  

% define protein surface of interest and overlapping and non-overlapping RNA
% spot of interest for quantification
protein_surface_number = 2;
overlapping_RNA_spot_number = 2;
nonoverlapping_RNA_spot_number = 3;

% define the decon channel of RNA spot of interest
decon_RNA_channel_number = '1';

% define intensity sum channel number for generalization
intensity_sum = 'Intensity Sum Channel';
decon_channel_RNA_intensity_sum = [intensity_sum, ' ', decon_RNA_channel_number];

% use dir function to list folder contents and select imaris files
ImarisImages=dir(fullfile(fpath,'*.ims'));

% define numbers of files
NumberImages=length(ImarisImages); 


for k=1:NumberImages                
   filename=ImarisImages(k).name;          %filename to analyze
   xPath=fullfile(fpath,filename);         %create filename
   imsObj=ImarisReader(xPath);             %read imaris file
   SurfaceStatistics=imsObj.Surfaces(protein_surface_number).GetStatistics;     %read surface statistics, this should be protein
   SpotStatisticsT=imsObj.Spots(overlapping_RNA_spot_number).GetStatistics;        %read spot statistics, this should be corresponding touching RNA
   SpotStatisticsN=imsObj.Spots(nonoverlapping_RNA_spot_number).GetStatistics;     %read spot statistics, this should be corresponding non-touching RNA

   %from SurfaceStatistics get centrosome coordinates centro (2x3 matrix)
   NumberSurface=size(SurfaceStatistics,2);
   for i=1:NumberSurface
       if strcmp (SurfaceStatistics(i).Name,"Volume") 
           Volume=SurfaceStatistics(i).Value;
        elseif strcmp (SurfaceStatistics(i).Name,"Position X") 
           PositionX=SurfaceStatistics(i).Value;
        elseif strcmp (SurfaceStatistics(i).Name,"Position Y") 
           PositionY=SurfaceStatistics(i).Value;
        elseif strcmp (SurfaceStatistics(i).Name,"Position Z") 
           PositionZ=SurfaceStatistics(i).Value;
       end
   end
   NumberProteinSurfaces=size(Volume);
   centro=zeros(2,3);
   largest=0;
   for j=1:2
       for i=1:NumberProteinSurfaces
           if Volume(i)==max(Volume)
               centro(j,1)=PositionX(i);
               centro(j,2)=PositionY(i);
               centro(j,3)=PositionZ(i);
               largest=i;
           end
       end
       Volume(largest)=0;
   end
        
   %from SpotStatistics get a new file with posX, posY, posZ, intensity sum
   %of RNA channel, touching
   NumberSpot=size(SpotStatisticsT,2);
   for i=1:NumberSpot
       if strcmp (SpotStatisticsT(i).Name,"Position X") 
           PositionX=SpotStatisticsT(i).Value;
        elseif strcmp (SpotStatisticsT(i).Name,"Position Y") 
           PositionY=SpotStatisticsT(i).Value;
        elseif strcmp (SpotStatisticsT(i).Name,"Position Z") 
           PositionZ=SpotStatisticsT(i).Value;
        elseif strcmp (SpotStatisticsT(i).Name,decon_channel_RNA_intensity_sum)   %select RNA channel
           IntensitySum=SpotStatisticsT(i).Value;
       end
   end
   TRNAfile=[PositionX,PositionY,PositionZ,IntensitySum];

   NumberTRNASpots=size(TRNAfile,1); 
   resultT=zeros(NumberTRNASpots,4);
   %generate distances and choose closest centrosome
   for i=1:NumberTRNASpots
       resultT(i,1)=TRNAfile(i,4);                           %this should be spot intensity selected above
       dist1=sqrt((TRNAfile(i,1)-centro(1,1))^2+(TRNAfile(i,2)-centro(1,2))^2+(TRNAfile(i,3)-centro(1,3))^2);
       dist2=sqrt((TRNAfile(i,1)-centro(2,1))^2+(TRNAfile(i,2)-centro(2,2))^2+(TRNAfile(i,3)-centro(2,3))^2);
       if dist1<dist2
           resultT(i,2)=1;
           resultT(i,3)=dist1;
       else
           resultT(i,2)=2;
           resultT(i,3)=dist2;
       end
   end
    
   %from SpotStatistics get a new file with posX, posY, posZ, intensity sum
   %of RNA channel, non-touching
   NumberSpot=size(SpotStatisticsN,2);
   for i=1:NumberSpot
       if strcmp (SpotStatisticsN(i).Name,"Position X") 
           PositionX=SpotStatisticsN(i).Value;
        elseif strcmp (SpotStatisticsN(i).Name,"Position Y") 
           PositionY=SpotStatisticsN(i).Value;
        elseif strcmp (SpotStatisticsN(i).Name,"Position Z") 
           PositionZ=SpotStatisticsN(i).Value;
        elseif strcmp (SpotStatisticsN(i).Name,decon_channel_RNA_intensity_sum)   %select RNA channel
           IntensitySum=SpotStatisticsN(i).Value;
       end
   end
   NRNAfile=[PositionX,PositionY,PositionZ,IntensitySum];

   NumberNRNASpots=size(NRNAfile,1); 
   resultN=zeros(NumberNRNASpots,4);
   %generate distances and choose closest centrosome
   for i=1:NumberNRNASpots
       resultN(i,1)=NRNAfile(i,4);                           %this should be spot intensity selected above
       dist1=sqrt((NRNAfile(i,1)-centro(1,1))^2+(NRNAfile(i,2)-centro(1,2))^2+(NRNAfile(i,3)-centro(1,3))^2);
       dist2=sqrt((NRNAfile(i,1)-centro(2,1))^2+(NRNAfile(i,2)-centro(2,2))^2+(NRNAfile(i,3)-centro(2,3))^2);
       if dist1<dist2
           resultN(i,2)=1;
           resultN(i,3)=dist1;
       else
           resultN(i,2)=2;
           resultN(i,3)=dist2;
       end
   end
   
   
   %generate histogram with 40 bins of 0.5 micron size
   histo=zeros(40,4);

   for j=1:40
      for i=1:NumberTRNASpots
          if resultT(i,2)==1
              if resultT(i,3)>0.5*(j-1)
                  if resultT(i,3)<0.5*j
                     histo(j,1)=histo(j,1)+resultT(i,1);
                  end
              end
          else
              if resultT(i,3)>0.5*(j-1)
                  if resultT(i,3)<0.5*j
                      histo(j,2)=histo(j,2)+resultT(i,1);
                  end
              end
          end
      end
      for i=1:NumberNRNASpots
          if resultN(i,2)==1
              if resultN(i,3)>0.5*(j-1)
                  if resultN(i,3)<0.5*j
                     histo(j,3)=histo(j,3)+resultN(i,1);
                  end
              end
          else
              if resultN(i,3)>0.5*(j-1)
                  if resultN(i,3)<0.5*j
                      histo(j,4)=histo(j,4)+resultN(i,1);
                  end
              end
          end
      end    
   end

   %xlswrite([path filename resultext],histo);                  %write out
   %histogram file, 4 columns, centro1 touch, centro2 touch, centro1 non
   %touch, centro2 non touch
   
   histoadd=zeros(40,3);
   for j=1:40
       histoadd(j,1)=0.5+(j-1)*0.5;
       histoadd(j,2)=histo(j,1)+histo(j,2);
       histoadd(j,3)=histo(j,3)+histo(j,4);
   end
   
   %xlswrite([path filename resultext],histoadd);                %write out
   %histogram file, 2 columns, touch, no touch

   totalRNA=sum(histoadd(:,2)+histoadd(:,3));
   
   Percenttouching=zeros(40,2);
   Touching=zeros(40,1);
   Percenttouching(:,1)=histoadd(:,1);
   Touching(1,1)=histoadd(1,2);
   for j=1:39
       Touching(j+1,1)=Touching(j,1)+histoadd(j+1,2);
   end
   Percenttouching(:,2)=Touching(:,1)/totalRNA;
   
% write out histogram file as CSV file
table_result = array2table(Percenttouching);
table_result.Properties.VariableNames{'Percenttouching1'} = 'distance_to_centrosome';
table_result.Properties.VariableNames{'Percenttouching2'} = 'percentage_of_overlapping_RNA_spots_with_protein_signals';
filetype = '.CSV';
OutPutName = [filename filetype]; 
OutputPath = fullfile(fpath, OutPutName);
writetable(table_result,OutputPath);
end